%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Avnonin 1964 - Linear flow                                              %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_avd_linear(r,z,h,lm,lm2,Cw,Cm,Cm2,vT,t,Q,ax)
%--Analytical solution----------------------------------------------------%
x = r;
v = vT*Cm/Cw;
tao = 4*lm2*t/h^2/Cm; 
ke = lm/lm2;
a = sqrt(lm2*Cm/lm/Cm2);
xm = 2*x/h;
gam = h*v*Cw/4/lm;

T = (xm/sqrt(pi*ke*tao))*quadgk(@(y) (1./y.^2).*...
   exp(-(gam*sqrt(ke*tao)*y-(xm/2/sqrt(ke*tao)./y)).^2).*...
   erfc(sqrt(tao/ke)*y.^2/2/a./sqrt(1-y.^2)),0,1);

%--Nomenclature-----------------------------------------------------------%
% r : radial coordinate [m]
% h : aqufer thickness [m]
% uz : thickness of the overlaying layer [m]
% k : bulk thermal conductivity of the aquifer [W/m/K]
% kd : bulk thermal conductivity of the overlaying layer [W/m/K]
% t : simulation time [s]
% vhcw : volumetric heat capacity of the water [J/m^3/K]
% vhcm : volumetric heat capacity of the porous medium (aquifer) [J/m^3/K]
% vhcmd : volumetric heat capacity of the porous medium (confining layers) [J/m^3/K]
% vT : heat transport velocity [m/s]
% ax: longitudinal thermal dispersivity
% Q : injection rate [m^3/s]